/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.client.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import morph.avaritia.client.model.CosmicBakedModel;
import net.covers1624.quack.gson.JsonUtils;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.geometry.IModelGeometry;

public class CosmicModelLoader
implements IModelLoader<CosmicModelGeometry> {
    public static final ResourceLocation ID = new ResourceLocation("avaritia", "cosmic");

    public void m_6213_(ResourceManager p_10758_) {
    }

    public CosmicModelGeometry read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
        JsonObject cosmicObj = modelContents.getAsJsonObject("cosmic");
        if (cosmicObj == null) {
            throw new IllegalStateException("Missing 'cosmic' object.");
        }
        String maskTexture = JsonUtils.getString((JsonObject)cosmicObj, (String)"mask");
        JsonObject clean = modelContents.deepCopy();
        clean.remove("cosmic");
        clean.remove("loader");
        BlockModel baseModel = (BlockModel)deserializationContext.deserialize((JsonElement)clean, BlockModel.class);
        return new CosmicModelGeometry(baseModel, maskTexture);
    }

    public static class CosmicModelGeometry
    implements IModelGeometry<CosmicModelGeometry> {
        private final BlockModel baseModel;
        private final String maskTexture;
        private Material maskMaterial;

        public CosmicModelGeometry(BlockModel baseModel, String maskTexture) {
            this.baseModel = baseModel;
            this.maskTexture = maskTexture;
        }

        public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
            BakedModel baseBakedModel = this.baseModel.m_111449_(bakery, this.baseModel, spriteGetter, modelTransform, modelLocation, true);
            return new CosmicBakedModel(baseBakedModel, spriteGetter.apply(this.maskMaterial));
        }

        public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            HashSet<Material> materials = new HashSet<Material>();
            this.maskMaterial = owner.resolveTexture(this.maskTexture);
            if (Objects.equals(this.maskMaterial.m_119203_(), MissingTextureAtlasSprite.m_118071_())) {
                missingTextureErrors.add((Pair<String, String>)Pair.of((Object)this.maskTexture, (Object)owner.getModelName()));
            }
            materials.add(this.maskMaterial);
            materials.addAll(this.baseModel.m_5500_(modelGetter, missingTextureErrors));
            return materials;
        }
    }
}

